﻿//
// $safeitemname$.xaml.cpp
// $safeitemname$ 类的实现
//

#include "pch.h"
#include "$safeitemname$.xaml.h"

using namespace $rootnamespace$;

using namespace Platform;
using namespace Platform::Collections;
using namespace Windows::ApplicationModel::Activation;
using namespace Windows::Foundation;
using namespace Windows::Foundation::Collections;
using namespace Windows::UI::Xaml;
using namespace Windows::UI::Xaml::Controls;
using namespace Windows::UI::Xaml::Controls::Primitives;
using namespace Windows::UI::Xaml::Data;
using namespace Windows::UI::Xaml::Input;
using namespace Windows::UI::Xaml::Interop;
using namespace Windows::UI::Xaml::Media;
using namespace Windows::UI::Xaml::Navigation;
using namespace Windows::Storage::Pickers::Provider;

// https://go.microsoft.com/fwlink/?LinkId=234239 上介绍了“文件开启选取器合约”项模板

$wizardcomment$$wizardregistrationcomment$$safeitemname$::$safeitemname$()
{
	InitializeComponent();
	SetValue(_defaultViewModelProperty, ref new Map<String^,Object^>(std::less<String^>()));
	Window::Current->SizeChanged += ref new WindowSizeChangedEventHandler (this, &$safeitemname$::Window_SizeChanged);
	InvalidateVisualState();
}

DependencyProperty^ $safeitemname$::_defaultViewModelProperty = nullptr;

void $safeitemname$::RegisterDependencyProperties()
{
	if (_defaultViewModelProperty == nullptr)
	{
		_defaultViewModelProperty =
			DependencyProperty::Register("DefaultViewModel",
				TypeName(IObservableMap<String^, Object^>::typeid), TypeName($safeitemname$::typeid), nullptr);
	}
}

/// <summary>
/// 用作普通视图模型。
/// </summary>
IObservableMap<String^, Object^>^ $safeitemname$::DefaultViewModel::get()
{
	return safe_cast<IObservableMap<String^, Object^>^>(GetValue(_defaultViewModelProperty));
}

/// <summary>
/// 在其他应用程序想要打开此应用程序中的文件时进行调用。
/// </summary>
/// <param name="e">用于与 Windows 协调进程的激活数据。</param>
void $safeitemname$::Activate(FileOpenPickerActivatedEventArgs^ e)
{
	_fileOpenPickerUI = e->FileOpenPickerUI;
	_fileOpenPickerUI->FileRemoved += 
		ref new TypedEventHandler<FileOpenPickerUI^,FileRemovedEventArgs^> (this,&$safeitemname$::FilePickerUI_FileRemoved);
		
	// TODO:  使用 DefaultViewModel->Insert("Files", <value>)，其中 <value> 是一个项集合，
	//     其中每项都应具有可绑定的 Image、Title 和 Description

	DefaultViewModel->Insert("CanGoUp", false);
	Window::Current->Content = this;
	Window::Current->Activate();
}

void $safeitemname$::Window_SizeChanged(Platform::Object^ sender, Windows::UI::Core::WindowSizeChangedEventArgs^ e)
{
	InvalidateVisualState();
}

void $safeitemname$::InvalidateVisualState()
{
	auto visualState = DetermineVisualState();
	Windows::UI::Xaml::VisualStateManager::GoToState(this, visualState, false);
}

/// <summary>
/// 在确定对应于应用程序视图状态的可视状态的名称时进行
/// 视图状态。
/// </summary>
/// <returns>所需的可视状态的名称。  此名称与视图状态的名称相同，
/// 但在纵向和对齐视图中存在选定项时例外，在纵向和对齐视图中，
/// 此附加逻辑页通过添加 _Detail 后缀表示。</returns>
Platform::String^ $safeitemname$::DetermineVisualState()
{
		return Windows::UI::Xaml::Window::Current->Bounds.Width >= 500 ? "HorizontalView" : "VerticalView";
}

/// <summary>
/// 当用户从选取器框中移除某一项目时调用
/// </summary>
/// <param name="sender">用于包含可用文件的 FileOpenPickerUI 实例。</param>
/// <param name="e">描述已移除文件的事件数据。</param>
void $safeitemname$::FilePickerUI_FileRemoved(FileOpenPickerUI^ sender, FileRemovedEventArgs^ e)
{
	// TODO: 响应在选取器 UI 中取消选择的项。
}

/// <summary>
/// 在选定的文件集合发生更改时进行调用。
/// </summary>
/// <param name="sender">用于显示可用文件的 GridView 实例。</param>
/// <param name="e">描述选择内容如何发生更改的事件数据。</param>
void $safeitemname$::FileGridView_SelectionChanged(Object^ sender, SelectionChangedEventArgs^ e)
{
	(void) sender;	// 未使用的参数
	(void) e;	// 未使用的参数

	// TODO:  使用 _fileOpenPickerUI->AddFile 和 _fileOpenPickerUI->RemoveFile 更新 Windows UI
}

/// <summary>
/// 在单击“转到上级”按钮时进行调用，并指示用户希望在文件
/// 的层次结构中提升一个级别。
/// </summary>
/// <param name="sender">用于表示“Go up”命令的 Button 实例。</param>
/// <param name="e">描述如何单击按钮的事件数据。</param>
void $safeitemname$::GoUpButton_Click(Object^ sender, RoutedEventArgs^ e)
{
	(void) sender;	// 未使用的参数
	(void) e;	// 未使用的参数

	// TODO:  使用 DefaultViewModel->Insert("CanGoUp", true) 启用相应的命令，
	//       使用 DefaultViewModel->Insert("Files", <value>) 反映文件层次结构遍历
}
